-- FireHardenedSpearFix.lua (B42.13.1)
-- Requires recipe override: OnTest:FHSF.OpenFire

local MOD = "FireHardenedSpearFix"
local DEBUG = getCore():getDebug()

local function dlog(msg)
    if not DEBUG then return end
    DebugLog.log(DebugType.General, "[" .. MOD .. "] " .. tostring(msg))
end

FHSF = FHSF or {}
FHSF._ctxCharacter = nil
FHSF._wrapped = false

local function isNearOpenFireForCharacter(chr)
    if not chr then return false end
    local sq = chr:getCurrentSquare()
    if not sq then return false end

    local squares = sq.getRadius and sq:getRadius(2) or nil
    if squares then
        for i = 0, squares:size() - 1 do
            local rsq = squares:get(i)
            if rsq then
                local objs = rsq:getObjects()
                for j = 0, objs:size() - 1 do
                    local obj = objs:get(j)
                    if obj then
                        if instanceof(obj, "IsoFireplace") or instanceof(obj, "IsoBarbecue") then
                            if obj.isLit and obj:isLit() then
                                return true
                            end
                        elseif instanceof(obj, "IsoThumpable") then
                            local md = obj:getModData()
                            if md and md.isLit == true then
                                return true
                            end
                        end
                    end
                end
            end
        end
    end

    if sq.hasAdjacentFireObject then
        return sq:hasAdjacentFireObject()
    end

    return false
end

-- This is what your recipe override calls: OnTest:FHSF.OpenFire
function FHSF.OpenFire(item)
    if not isServer() then
        -- client can be permissive; server is authority and will re-run this during consume/perform
        return true
    end

    local chr = FHSF._ctxCharacter
    if not chr then
        dlog("OpenFire called with no context character")
        return false
    end

    return isNearOpenFireForCharacter(chr)
end

local function wrapHandcraft()
    if FHSF._wrapped then return end

    local ok = pcall(require, "Entity/TimedActions/ISHandcraftAction")
    if not ok or not ISHandcraftAction then
        dlog("ISHandcraftAction not available")
        return
    end

    FHSF._wrapped = true

    local oldServerStart = ISHandcraftAction.serverStart
    ISHandcraftAction.serverStart = function(self, ...)
        local prev = FHSF._ctxCharacter
        FHSF._ctxCharacter = self and self.character or nil

        local ok2, ret = pcall(oldServerStart, self, ...)

        FHSF._ctxCharacter = prev
        if not ok2 then error(ret) end
        return ret
    end

    local oldPerformRecipe = ISHandcraftAction.performRecipe
    ISHandcraftAction.performRecipe = function(self, ...)
        local prev = FHSF._ctxCharacter
        FHSF._ctxCharacter = self and self.character or nil

        local ok2, ret = pcall(oldPerformRecipe, self, ...)

        FHSF._ctxCharacter = prev
        if not ok2 then error(ret) end
        return ret
    end

    dlog("Wrapped ISHandcraftAction.serverStart + performRecipe")
end

wrapHandcraft()
